'use strict';_={add:" You define a <u>tab selection</u> by specifying filters, sorting and <br> other operations. You can add any number of operations and <br>\n each will apply to the result of the previous one. <hr b> For example, this sequence of operations: <hr b>\n <c hl>1. <c sml>FILTER</c></c> <hr b>\n <c hl>2. <c sml>SORT</c></c> <hr b>\n <c hl>3. <c sml>SLICE</c></c> <hr b>\n <hr b>\n will first <b u>filter</b> the set of tabs, then will <b u>sort</b> the set and then <br> <b u>slice</b> the set. <br>\n The final result of your <u>tab selection</u> is the set of tabs after all <br> operations are applied.\n ",
filter:" Filter the set of tabs by a given condition.",slice:" Get a subset of tabs by slicing the current set.",sort:" Order the set of tabs by a given sorting criteria.",groupBy:" Separate the set of tabs in groups. Following operations <br> will be applied to each group separately.",mergeGrp:" Merge the groups back into a single group.",addSet:" Add a set of tabs to the existing set or replace <br> it with a new set. <br> The new set will be added as a separate group.",adRf:" Include the <c h=@/refTab>reference tab</c> itself in the resulting set. \n ",
wrp:" Treat the set of tabs as a circular list. Each end <br> of the list will continue on the opposite end.\n ",neg:" Invert the filter condition. That is, tabs that DO NOT <br> match the condition will pass the filter.\n ",frTo:" <b u>From</b> and <b u>To</b> are the beginning and end of the slice. <br>\n Negative positions count from the end, that is, <b>-1</b> <br> is the last tab, <b>-2</b> is the second to last, and so on.\n ",grWs:" When the set of tabs is separated in groups, <br> perform the operation on the <u>set of groups</u> <br> instead of on each <u>group of tabs</u>.",
refTab:" A <b>reference tab</b> is a tab you specify in some filter conditions <br> to make comparisons with other tabs or as a reference point. <br>\n This tab is highlighted in yellow in the <b>Result</b> panel.\n ",refCmp:" Compare to a <c h=@/refTab>reference tab</c>.\n ",repl:" Replace the current set of tabs instead of adding to it. <hr b> This is useful if your wish to apply additional filters and <br> sorting\n to another tab selection. i.e. you can build a new <br> tab selection using another one as a starting point.\n ",
mSl:" A tab will pass the filter if it's in any of the states you select here. <hr b=3>\n <b>Marked:</b> <c ib>A tab is marked <{mSl_aux}> <c h=mnuSltn/selTypes/mrkd>marked</c>.</c> <hr b=3>\n <b>Hilited:</b> <c ib>A tab is highlited <{mSl_aux}> <c h=mnuSltn/selTypes/hltd>highlighted</c>.</c>  <hr b=3>\n <b>Hovered:</b> <c ib>A tab is hovered <{mSl_aux}> <c h=mnuSltn/selTypes/hvrd>hovered</c>.</c>\n ",mnMxGS:" The minimum and maximum amount of tabs the group <br> must have. If the tab group has less or more tabs than <br> specified here,\n the entire group is discarded. <br> This filter is applied to each group separately, not to the <br> set of tabs as a whole.\n ",
mSl_aux:" if its corresponding <c h=mnuSltn/types/tab>menu item</c> or <br> containing <c h=mnuSltn/types/tbGrp>tab submenu</c> is",mnuSltn:()=>"file55.js",tgtExpr:{act:" Whether a tab is <c h=/actTab>active</c> or not.",hl:" Whether a tab is <c h=/selTab>selected</c> or not.",pin:" Whether a tab is pinned or not.",aud:" Whether a tab is <c h=/audTab>audible</c> or not.",mut:" Whether a tab is muted or not.",usd:" Whether a tab has ever been <c h=/actTab>active</c>.",sts:" Whether a tab's content is still loading, <br> already loaded or <c h=/uldTab>unloaded</c>.",
icg:" Whether a tab is an incognito tab. <hr b> <{/reqIncg}>",idx:" The position of a tab in its own window. <br> The leftmost tab in a window is position #1.",foc:" Whether a tab is in the <c h=/focWin>focused window</c>.",wTy:" The type of window a tab is in. <u>Normal</u>, <u>popup</u>, etc.",wSt:' Whether a tab is in a minimized, maximized, restored <br> (also called "normal"), fullscreen or hidden window.',aot:" Whether a tab is in a <c h=/aotWin>topmost window</c> or not.",pnt:" Whether a tab is in the window hovered over by the mouse, <br> which can be different from the <c h=/focWin>focused window</c>.",
tGr:" All tabs that belong to the same <c h=/actions/tbStGrp>tab-strip group</c> <br> as a <c h=@/refTab>reference tab</c>.",fav:" Whether a tab is in a given <c h=/favLst>favorite list</c>.",evt:" Whether a tab is an <c h=/tse/evt>event tab</c> or not.",hvr:" <{/noSuprt}> Whether a tab is being hovered over by the mouse in the <br> tab strip. <hr b=2> <{/triggers/region/tabArea}> <{MORE}> <{/hvrTabMore}>",grp:" Whether a tab is in a <c h=/actions/tbStGrp>tab-strip group</c> or not.",mSl:" Filter the tabs by whether they are marked, highlighted <br> or hovered in an <c h=/actions/menu>AutoControl menu</c>.",
pos:" a <c h=@/refTab>reference tab</c> in the <br> set (according to the set's current order, which can be <br> changed with the <b>SORT</b> operation).",prv:" The tab that's immediately before <{pos}>",nxt:" The tab that's immediately after <{pos}>",bef:" All tabs that are before <{pos}>",aft:" All tabs that are after <{pos}>",grS:' Filter tab groups by the amount of tabs they contain. <hr b> These groups are created with the "<b>GROUP BY</b>" operation <br>\n found in the "<u blr><c style="font: 14px arial">+</c> Add operation</u>" menu.',
url:" Filter tabs according to their <c h=/url>URL</c>.",dom:" Filter tabs according to their <c h=/domPrt>domain</c>.",mDom:" Filter tabs according to their <c h=/mDomPrt>main domain</c>.",pth:" Filter tabs according to their <c h=/pthPrt>URL path</c>.",tit:" Filter tabs according to their title.",mon:" Tabs in a given monitor. If you only have <br> one monitor, this filter does nothing."},refExpr:{act:" The <c h=/actTab>active</c> state of the <br> reference tab (<b>On</b> or <b>Off</b>).",hl:" The <c h=/selTab>selected</c> state of the <br> reference tab (<b>On</b> or <b>Off</b>).",
pin:" The pinned state of the <br> reference tab (<b>On</b> or <b>Off</b>).",aud:" The <c h=/audTab>audible</c> state of the <br> reference tab (<b>On</b> or <b>Off</b>).",mut:" The muted state of the <br> reference tab (<b>On</b> or <b>Off</b>).",usd:' The "used" state of the reference tab (<b>On</b> or <b>Off</b>). <br> i.e. whether the reference tab has ever been <c h=/actTab>active</c>.',sts:" The load status of the reference <br> tab (Loading, Loaded, Unloaded).",icg:" The incognito mode of the reference tab (<b>On</b> or <b>Off</b>). <hr b> <{/reqIncg}>",
idx:" The position of the reference <br> tab in its own window.",foc:" The <c h=/focWin>focus state</c> of the window the <br> reference tab is in (<b>On</b> or <b>Off</b>).",wTy:" The type of window the reference tab <br> is in (Normal, Pop-up, DevTools).",wSt:" The state of the window the reference tab <br> is in (Minimized, Maximized, etc.).",aot:" The <c h=/aotWin>topmost state</c> of the window the <br> reference tab is in (<b>On</b> or <b>Off</b>).",pnt:' The "hovered" state of the window the reference <br> tab is in (<b>On</b> or <b>Off</b>).\n That is, whether the reference <br> tab\'s containing window is being hovered over by <br> the mouse.',
hvr:" The <c h=../tgtExpr/hvr>hovered</c> state of the <br> reference tab (<b>On</b> or <b>Off</b>).",url:" The <c h=/url>URL</c> of the reference tab.",dom:" The <c h=/domPrt>domain</c> of the reference tab.",mDom:" The <c h=/mDomPrt>main domain</c> of the reference tab.",pth:" The <c h=/pthPrt>URL path</c> of the reference tab.",tit:" The title of the reference tab.",mon:" The monitor the reference tab is in."},order:{nrm:" The order the tabs have in their own window, from left to right. <br> Different windows are in create order.",
mru:" The order in which you've used each tab. From the tab <br> you used first till the tab you used last, i.e. most recently.",opn:" The order in which tabs were first opened (i.e. created).",zOrd:" The order in which different windows are stacked on the <br> desktop. Tabs in the same window will be in <u>use order</u>.",dom:" Order by the <c h=/domPrt>domain</c> part of the URL.",mdom:" Order by the <c h=/mDomPrt>main domain</c> of the URL.",pth:" Order by the <c h=/pthPrt>path</c> part of the URL.",
inv:" Invert the current order of the tab set."},dsc:" <b>Ascending:</b> From first to last. <br>\n <b>Descending:</b> From last to first.\n ",expr:{win:" Group tabs that belong to the same window.",wTy:" Group tabs by the type of their containing <br> window (normal or pop-up).",wSt:" Group tabs by the state of their containing window <br> (minimized, maximized, restored, fullscreen, hidden).",mon:" Group tabs that are in the same monitor. If you <br> have only one monitor, this has no effect.",
ovr:" Tabs occupying the same area of the desktop (i.e. they <br> overlap each other) will be grouped together. <br>\n Tabs in the same window always overlap each other, so <br> they will be in the same groups too.",tGr:" Group tabs that belong to the same <c h=/actions/tbStGrp>tab-strip group</c>.",tit:" Group tabs with the exact same title.",url:" Group tabs with the exact same URL.",dom:" Group tabs by their <c h=/domPrt>domain</c>.",mdom:" Group tabs by their <c h=/mDomPrt>main domain</c>.",pth:" Group tabs with the same <c h=/pthPrt>URL path</c>.",
hl:" Group tabs by whether they are <c h=/selTab>selected</c> or not.",pin:" Group tabs by whether they are pinned or not.",aud:" Group tabs by whether they are <c h=/audTab>audible</c> or not.",mut:" Group tabs by whether they are muted or not.",sts:" Group tabs by whether their content is <br> still loading, already loaded or <c h=/uldTab>unloaded</c>.",icg:" Group tabs by whether they are incognito tabs or not. <hr b> <{/reqIncg}>"},res:" See the result of your <u>tab selection</u> step by step so you can <br> understand what's happening on each operation. <hr b>\n Keep in mind that this result is just an example based on the <br> tabs you have open right now. <br>\n The result panel will update live as you make changes to your <br> tabs, like opening and closing tabs, pinning, moving, etc.\n ",
iSet:" A <u>tab selection</u> starts with all your open tabs. This is called the <br> <b>Initial Set</b>. The first operation in the\n <u>tab selection</u> is applied to <br> this set, and then, each subsequent operation is applied to the <br> result of the previous one.\n <{MORE}> <hr b=2>\n In an <u>inner tab selection</u>, that is, a tab selection that's inside <br> another, the <b>Initial Set</b>\n is not all your open tabs but rather the <br> tab set which the <u>inner tab selection</u> is being applied to. <hr b>\n You'll know when you are in this situation as it's self-evident. <hr b>\n You can use the <c b h=@/addSet>ADD TABS</c> operation if the <b>Initial Set</b> doesn't <br> contain the tabs you need.\n "};
